import 'package:admin_desktop/infrastructure/constants/constants.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/catalogue/widgets/service_master/riverpod/service_master/service_master_provider.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/application/providers.dart';
import 'package:admin_desktop/domain/models/models.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import '../../../../../../../../app_constants.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import '../riverpod/service_master/add/add_service_master_provider.dart';
import '../widgets/services_modal.dart';

class AddServiceMasterPage extends ConsumerStatefulWidget {
  const AddServiceMasterPage({
    super.key,
  });

  @override
  ConsumerState<AddServiceMasterPage> createState() => _AddServicePageState();
}

class _AddServicePageState extends ConsumerState<AddServiceMasterPage> {
  final _formKey = GlobalKey<FormState>();
  late TextEditingController commission;
  late TextEditingController pause;
  late TextEditingController price;
  late TextEditingController interval;
  late TextEditingController master;
  late TextEditingController service;
  late TextEditingController discount;
  UserData? selectMaster;
  ServiceData? selectService;

  @override
  void initState() {
    commission = TextEditingController();
    pause = TextEditingController();
    price = TextEditingController();
    interval = TextEditingController();
    master = TextEditingController();
    service = TextEditingController();
    discount = TextEditingController();
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      ref.read(addServiceMasterProvider.notifier).clear();
      ref.read(addServiceMasterProvider.notifier).setGender("all");
    });
  }

  @override
  void dispose() {
    commission.dispose();
    pause.dispose();
    price.dispose();
    interval.dispose();
    master.dispose();
    service.dispose();
    discount.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    final state = ref.watch(addServiceMasterProvider);
    final notifier = ref.read(addServiceMasterProvider.notifier);
    return KeyboardDisable(
      child: Container(
          padding: EdgeInsets.all(8),
          width: 590,
          decoration: BoxDecoration(
              color: Style.white,
              borderRadius: BorderRadius.circular(AppConstants.radius)),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisSize: MainAxisSize.min,
            children: [
              Row(
                children: [
                  BackButton(
                    onPressed: () {
                      Navigator.pop(context);
                      // ref.read(catalogueProvider.notifier).changeState(3);
                    },
                  ),
                  20.horizontalSpace,
                  Text(
                    AppHelpers.getTranslation(TrKeys.addService),
                    style: Style.interMedium(size: 20),
                  ),
                ],
              ),
              SingleChildScrollView(
                padding: REdgeInsets.symmetric(horizontal: 16),
                physics: const BouncingScrollPhysics(),
                child: Form(
                  key: _formKey,
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.end,
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      16.verticalSpace,
                      Row(
                        children: [
                          Expanded(
                            child: OutlinedBorderTextField(
                              readOnly: true,
                              onTap: () {
                                AppHelpers.showAlertDialog(
                                  context: context,
                                  child: ServicesModal(
                                    onChange: (value) {
                                      selectService = value;
                                      service.text =
                                          value.translation?.title ?? '';
                                      interval.text = "${value.interval ?? 0}";
                                      pause.text = "${value.pause ?? 0}";
                                      price.text = "${value.price ?? 0}";
                                    },
                                  ),
                                );
                              },
                              label:
                                  "${AppHelpers.getTranslation(TrKeys.service)}*",
                              textInputAction: TextInputAction.next,
                              validator: AppValidators.emptyCheck,
                              textController: service,
                            ),
                          ),
                          12.horizontalSpace,
                          Expanded(
                            child: OutlinedBorderTextField(
                              label:
                                  '${AppHelpers.getTranslation(TrKeys.interval)}*',
                              textInputAction: TextInputAction.next,
                              textController: interval,
                              inputType: TextInputType.number,
                              validator: AppValidators.isNumberValidator,
                              inputFormatters: [InputFormatter.digitsOnly],
                            ),
                          ),
                        ],
                      ),
                      16.verticalSpace,
                      Row(
                        children: [
                          Expanded(
                            child: OutlinedBorderTextField(
                              label:
                                  '${AppHelpers.getTranslation(TrKeys.pause)}*',
                              textInputAction: TextInputAction.next,
                              inputType: TextInputType.number,
                              textController: pause,
                              validator: AppValidators.isNumberValidator,
                              inputFormatters: [InputFormatter.digitsOnly],
                            ),
                          ),
                          12.horizontalSpace,
                          Expanded(
                            child: OutlinedBorderTextField(
                              label:
                                  '${AppHelpers.getTranslation(TrKeys.price)}*',
                              textInputAction: TextInputAction.next,
                              textController: price,
                              inputType: TextInputType.number,
                              validator: AppValidators.emptyCheck,
                              inputFormatters: [InputFormatter.currency],
                            ),
                          ),
                        ],
                      ),
                      16.verticalSpace,
                      Row(
                        children: [
                          Expanded(
                            child: OutlinedBorderTextField(
                              label: AppHelpers.getTranslation(
                                  TrKeys.commissionFee),
                              textInputAction: TextInputAction.done,
                              textController: commission,
                              inputType: TextInputType.number,
                              inputFormatters: [InputFormatter.currency],
                            ),
                          ),
                          12.horizontalSpace,
                          Expanded(
                            child: OutlineDropDown(
                              label: TrKeys.gender,
                              hint: TrKeys.all,
                              list: DropDownValues.genderList,
                              onChanged: notifier.setGender,
                            ),
                          ),
                        ],
                      ),
                      60.verticalSpace,
                      CustomButton(
                        textColor: Style.white,
                        title: AppHelpers.getTranslation(TrKeys.save),
                        isLoading: state.isLoading,
                        onTap: () {
                          if ((_formKey.currentState?.validate() ?? false) &&
                              ref.watch(editMastersProvider).masterData?.id !=
                                  null) {
                            notifier.createService(
                              context,
                              created: (service) {
                                AppHelpers.showSnackBar(
                                  context,
                                  AppHelpers.getTranslation(
                                      TrKeys.successfullyCreated),
                                );
                                ref
                                    .read(serviceMasterProvider.notifier)
                                    .fetchServices(
                                        context: context,
                                        isRefresh: true,
                                        masterId: ref
                                            .watch(editMastersProvider)
                                            .masterData
                                            ?.id);
                                Navigator.pop(context);
                              },
                              onError: () {},
                              price: price.text,
                              interval: interval.text,
                              discount: discount.text,
                              pause: pause.text,
                              masterId:
                                  ref.watch(editMastersProvider).masterData?.id,
                              serviceId: selectService?.id ?? 0,
                              commissionFee: commission.text,
                              gender: notifier.gender,
                            );
                            //     .then((d){
                            //   ref.read(catalogueProvider.notifier).changeState(3);
                            // });
                          }
                        },
                      ),
                      20.verticalSpace,
                    ],
                  ),
                ),
              ),
            ],
          )),
    );
  }
}
